/**
 * @version $Id: slideshow.js 99 2017-08-04 10:55:30Z szymon $
 * @package DJ-MediaTools
 * @subpackage DJ-MediaTools slideshow layout
 * @copyright Copyright (C) 2017 DJ-Extensions.com, All rights reserved.
 * @license DJ-Extensions.com Proprietary Use License
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 * @developer Szymon Woronowski - szymon.woronowski@design-joomla.eu
 *
 */
!function(t){var i=window.DJImageSlideshow=window.DJImageSlideshow||function(t,i){this.options={autoplay:0,transition:"linear",duration:800,delay:3e3,ifade_multiplier:2,wcag:1},this.init(t,i)};i.prototype.init=function(i,e){var s=this;if(jQuery.extend(s.options,e),s.slider=t("#"+i),s.slider.length&&(s.slides=s.slider.find(".dj-slide"),s.descriptions=s.slider.find(".dj-slide-desc"),s.current=0,s.pauseAutoplay=0,s.loader=s.slider.find(".dj-loader").first(),s.loading=1,s.visible||(s.visible=1),s.last=s.slides.length-s.slides.length%s.visible,s.last==s.slides.length&&(s.last-=s.visible),s.transition=s.support("transition"),s.transform=!("ifade"!=s.options.slider_type||!s.transition)&&s.support("transform"),s.slides.length)){s.setEffectsOptions(),s.setSlidesEffects(),s.setNavigation(),s.setIndicators(),s.setSliderEvents(),s.responsive(),s.loadFirstSlide();var o;t(window).on("resize",function(){clearTimeout(o),o=setTimeout(s.responsive.bind(s),200)}),t(window).on("load",s.responsive.bind(s))}},i.prototype.setEffectsOptions=function(){var t=this;switch(t.options.slider_type){case"up":t.property="top",t.startEffect={top:t.options.height+t.options.spacing,opacity:0},t.backEffect={top:-1*(t.options.height+t.options.spacing),opacity:0},t.endEffect={top:0,opacity:1};break;case"down":t.property="top",t.startEffect={top:-1*(t.options.height+t.options.spacing),opacity:0},t.backEffect={top:t.options.height+t.options.spacing,opacity:0},t.endEffect={top:0,opacity:1};break;case"left":t.property="left",t.startEffect={left:t.options.width+t.options.spacing},t.backEffect={left:-1*(t.options.width+t.options.spacing)},t.endEffect={left:0};break;case"right":t.property="left",t.startEffect={left:-1*(t.options.width+t.options.spacing)},t.backEffect={left:t.options.width+t.options.spacing},t.endEffect={left:0};break;case"fade":case"ifade":default:t.property="opacity",t.startEffect={opacity:0},t.endEffect={opacity:1}}if(t.options.desc_effect)switch(t.options.desc_effect){case"up":t.desc_property="margin-bottom",t.desc_startEffect={marginBottom:t.options.height+t.options.spacing},t.desc_endEffect={marginBottom:0};break;case"down":t.desc_property="margin-bottom",t.desc_startEffect={marginBottom:-1*(t.options.height+t.options.spacing)},t.desc_endEffect={marginBottom:0};break;case"left":t.desc_property="margin-left",t.desc_startEffect={marginLeft:-1*(t.options.width+t.options.spacing)},t.desc_endEffect={marginLeft:0};break;case"right":t.desc_property="margin-left",t.desc_startEffect={marginLeft:t.options.width+t.options.spacing},t.desc_endEffect={marginLeft:0};break;case"fade":default:t.desc_property="opacity",t.desc_startEffect={opacity:0},t.desc_endEffect={opacity:1}}},i.prototype.loadFirstSlide=function(){var i=this;if(i.slider.find(".dj-slides").first().css("opacity",0),i.options.preload)i.preloadImage(i.current,!1),setTimeout(i.firstSlideLoaded,i.options.preload);else{var e=t(i.slides[i.current]).find("img.dj-image").first(),s=function(t){this.firstSlideLoaded(),t.off("load",s)}.bind(i,e);e.on("load",s),i.preloadImage(i.current,!1)}},i.prototype.firstSlideLoaded=function(){var t=this;t.loader.fadeOut(200),t.slider.find(".dj-slides").first().animate({opacity:1},200),setTimeout(function(){t.autoPlay()},t.options.delay+500),t.preloadImage(t.current+1,!1),t.loading--},i.prototype.setSlidesEffects=function(){for(var i=this,e=0;e<i.slides.length;e++)e==i.current?t(i.slides[e]).css(i.endEffect):(t(i.slides[e]).css("visibility","hidden"),t(i.slides[e]).css(i.startEffect));if("ifade"==i.options.slider_type){i.images=[];for(var s=!!i.transform&&i.transform+" "+i.options.duration/2+"ms cubic-bezier(0.190, 1.000, 0.220, 1.000)",e=0;e<i.slides.length;e++)i.images[e]=t(i.slides[e]).find(".dj-image"),i.images[e].length&&(s?(i.images[e].css(i.transition,s),e!=i.current&&i.images[e].css(i.transform,"scale("+i.options.ifade_multiplier+")")):i.images[e].css("max-width","none"))}if(i.options.desc_effect)for(e=0;e<i.descriptions.length;e++)e==i.current?t(i.descriptions[e]).css(i.desc_endEffect):(t(i.descriptions[e]).css("visibility","hidden"),t(i.descriptions[e]).css(i.desc_startEffect))},i.prototype.setNavigation=function(){var t=this;t.nextButton=t.slider.find(".dj-navigation .dj-next").first(),t.nextButton.length&&t.nextButton.on("click",function(i){t.nextSlide(),i.preventDefault(),i.stopPropagation()}),t.prevButton=t.slider.find(".dj-navigation .dj-prev").first(),t.prevButton.length&&t.prevButton.on("click",function(i){t.prevSlide(),i.preventDefault(),i.stopPropagation()}),t.playButton=t.slider.find(".dj-navigation .dj-play").first(),t.pauseButton=t.slider.find(".dj-navigation .dj-pause").first(),t.playButton.length&&t.pauseButton.length&&(t.options.autoplay?t.playButton.css("display","none"):t.pauseButton.css("display","none"),t.playButton.on("click",function(i){t.options.autoplay=1,t.playButton.css("display","none"),t.pauseButton.css("display","block").focus(),i.preventDefault(),i.stopPropagation()}),t.pauseButton.on("click",function(i){t.options.autoplay=0,t.pauseButton.css("display","none"),t.playButton.css("display","block").focus(),i.preventDefault(),i.stopPropagation()}))},i.prototype.setIndicators=function(){var i=this;i.indicators=i.slider.find(".dj-indicators .dj-load-button"),i.indicators.length&&i.indicators.each(function(e){indicator=t(this),indicator.on("click",function(t){i.loadSlide(e*i.visible),t.preventDefault(),t.stopPropagation()})})},i.prototype.setSliderEvents=function(){var i=this;i.options.navi_margin<0&&(i.slider.css("padding-left",-1*i.options.navi_margin),i.slider.css("padding-right",-1*i.options.navi_margin));var e=i.slider.find("a[href], input, select, textarea, button");i.options.wcag&&(i.slider.prop("tabindex","0"),e.prop("tabindex","-1")),i.slider.on("mouseenter",function(){i.pauseAutoplay=i.options.pause_autoplay,i.playButton.length&&i.pauseButton.length&&(i.playButton.css("visibility",""),i.pauseButton.css("visibility",""))}).on("mouseleave",function(){i.slider.removeClass("focused"),i.pauseAutoplay=0}),i.options.wcag&&(i.slider.on("focus",function(){i.options.wcag&&(e.removeProp("tabindex"),i.slider.addClass("focused"),i.slider.trigger("mouseenter"),i.pauseAutoplay=1)}).on("keydown",function(t){var e=t.which;37!=e&&39!=e||(39==e?"right"==i.options.slider_type?i.prevSlide():i.nextSlide():"right"==i.options.slider_type?i.nextSlide():i.prevSlide(),i.slider.focus(),t.preventDefault(),t.stopPropagation())}),i.slider.next(".djslideshow-end").prop("tabindex","0").on("focus",function(){e.prop("tabindex","-1"),i.slider.trigger("mouseleave")})),i.slider.djswipe(function(t,e){e.x<50||e.y>50||("left"==t.x?"right"==i.options.slider_type?i.prevSlide():i.nextSlide():"right"==t.x&&("right"==i.options.slider_type?i.nextSlide():i.prevSlide()))}),i.slides.each(function(){var i=t(this);i.find(".video-icon").css("cursor","pointer").click(function(){i.find("a.dj-slide-link").click()})})},i.prototype.prevSlide=function(){var t=this;t.current<t.visible?t.loadSlide(t.last):t.loadSlide(t.current-t.visible)},i.prototype.nextSlide=function(){var t=this;t.current>=t.last?t.loadSlide(0):t.loadSlide(t.current+t.visible)},i.prototype.preloadImage=function(i,e){var s=this;if(s.exist(i)){var o=t(s.slides[i]).find("img.dj-image").first();if(!s.slides[i].loaded){if(s.slides[i].loaded=!0,o.removeAttr("src"),e){s.loading++,s.loader.fadeIn(200);var n=function(t,i){t.length>1&&(i=t[1],t=t[0]),--s.loading||(s.loader.fadeOut(200),i-=i%s.visible,s.loadSlide(i)),t.off("load",n)}.bind(s,[o,i]);o.on("load",n)}o.data();var a=o.data("sizes"),d=o.data("srcset"),r=o.data("src");o.removeAttr("data-sizes data-srcset data-src"),a&&d?(o.attr("sizes",a),o.attr("srcset",d),picturefill({elements:[o[0]]})):o.attr("src",r)}}},i.prototype.loadSlide=function(i){var e=this;e.current==i||e.loading||(t(e.slides[i]).find("img.dj-image").first().length&&!e.slides[i].loaded?e.preloadImage(i,!0):(e.slide(e.current,i),i<e.slides.length-1&&e.preloadImage(i+1,!1),e.setCurrentSlide(i)))},i.prototype.exist=function(t){return t in this.slides},i.prototype.slide=function(i,e){var s=this;"fade"==s.options.slider_type?(s.loading++,s.exist(i)&&t(s.slides[i]).animate(s.startEffect,s.options.duration,s.options.transition),s.exist(e)&&(t(s.slides[e]).css("visibility","visible"),t(s.slides[e]).animate(s.endEffect,s.options.duration,s.options.transition)),setTimeout(function(i){s.loading--,s.exist(i)&&t(s.slides[i]).css("visibility","hidden")}.bind(s,i),s.options.duration)):"ifade"==s.options.slider_type?(s.loading++,s.transform||(s.exist(i)&&!s.images[i].startWidth&&(s.images[i].startWidth=s.getSize(t(s.images[i])).x,s.images[i].sWidth=s.sliderWidth),s.exist(e)&&!s.images[e].startWidth&&(s.images[e].startWidth=s.getSize(t(s.images[e])).x,s.images[e].sWidth=s.sliderWidth)),s.exist(i)&&(s.transform?t(s.images[i]).css(s.transform,"scale("+s.options.ifade_multiplier+")"):t(s.images[i]).css({width:s.images[i].startWidth}).animate({width:s.options.ifade_multiplier*s.images[i].startWidth},s.options.duration/2,s.options.transition),t(s.slides[i]).animate(s.startEffect,s.options.duration/2,s.options.transition)),setTimeout(function(i,e){i.length>1&&(e=i[1],i=i[0]),s.exist(i)&&(t(s.slides[i]).css("visibility","visible"),s.transform?t(s.images[i]).css(s.transform,"scale(1)"):t(s.images[i]).css({width:s.options.ifade_multiplier*s.images[i].startWidth}).animate({width:s.images[i].startWidth},s.options.duration/2,s.options.transition),t(s.slides[i]).animate(s.endEffect,s.options.duration/2,s.options.transition)),setTimeout(function(i){s.loading--,s.exist(i)&&t(s.slides[i]).css("visibility","hidden")}.bind(s,e),s.options.duration/2)}.bind(s,e,i),s.options.duration/2)):(t(s.slides[e]).css("visibility","visible"),e>=i&&(e<s.last||i-i%s.visible!=0)||e-e%s.visible==0&&i>=s.last?(s.exist(i)&&t(s.slides[i]).css(s.endEffect).animate(s.backEffect,s.options.duration,s.options.transition),s.exist(e)&&t(s.slides[e]).css(s.startEffect).animate(s.endEffect,s.options.duration,s.options.transition)):(s.exist(i)&&t(s.slides[i]).css(s.endEffect).animate(s.startEffect,s.options.duration,s.options.transition),s.exist(e)&&t(s.slides[e]).css(s.backEffect).animate(s.endEffect,s.options.duration,s.options.transition)),setTimeout(function(i){t(s.slides[i]).css("visibility","hidden")}.bind(s,i),s.options.duration)),s.options.desc_effect&&(s.exist(e)&&"fade"!=s.options.slider_type&&"ifade"!=s.options.slider_type&&s.loading++,s.exist(i)&&t(s.descriptions[i]).animate(s.desc_startEffect,s.options.duration/2,s.options.transition),setTimeout(function(i,e){i.length>1&&(e=i[1],i=i[0]),s.exist(e)&&t(s.descriptions[e]).css("visibility","hidden"),s.exist(i)&&(t(s.descriptions[i]).css("visibility","visible"),t(s.descriptions[i]).animate(s.desc_endEffect,s.options.duration/2,s.options.transition),"fade"!=s.options.slider_type&&"ifade"!=s.options.slider_type&&setTimeout(function(){s.loading--}.bind(s),s.options.duration/2))}.bind(s,e,i),s.options.duration/2))},i.prototype.setCurrentSlide=function(i){var e=this;e.slides.removeClass("dj-active"),t(e.slides[i]).addClass("dj-active"),e.indicators.length&&(e.indicators.removeClass("dj-load-button-active"),t(e.indicators[Math.ceil(i/e.visible)]).addClass("dj-load-button-active")),e.playButton.length&&e.pauseButton.length&&(e.playButton.css("visibility","hidden"),e.pauseButton.css("visibility","hidden")),e.current=i},i.prototype.autoPlay=function(){var t=this;t.options.autoplay&&!t.pauseAutoplay&&t.nextSlide(),setTimeout(t.autoPlay.bind(t),t.options.delay)},i.prototype.getSize=function(i){var e={};if(i.is(":hidden")){for(var s,o,n=i.parent();n.is(":hidden");)s=n,n=n.parent();o=n.width(),s&&(o-=parseInt(s.css("margin-left")),o-=parseInt(s.css("margin-right")),o-=parseInt(s.css("border-left-width")),o-=parseInt(s.css("border-right-width")),o-=parseInt(s.css("padding-left")),o-=parseInt(s.css("padding-right")));var a=i.clone();a.css({position:"absolute",visibility:"hidden","max-width":o}),t(document.body).append(a),e={x:a.width(),y:a.height()},a.remove()}else e={x:i.width(),y:i.height()};return e},i.prototype.responsive=function(){var i=this;if("ifade"==i.options.slider_type&&!i.transform)for(var e=0;e<i.images.length;e++)i.images[e].startWidth&&(i.images[e].iWidth||(i.images[e].iWidth=i.images[e].startWidth),i.images[e].startWidth=i.images[e].iWidth*(newSliderWidth/i.images[e].sWidth),t(i.images[e]).css("width",t(i.images[e]).startWidth));var s=t(window).width();i.slides.each(function(){var i=t(this).find("img.dj-image").first(),e=Math.floor(100*i.width()/s);i.attr("data-sizes")?i.attr("data-sizes",e+"vw"):i.attr("sizes",e+"vw")})},i.prototype.support=function(t){var i=(document.body||document.documentElement).style;if(void 0===i)return!1;if("string"==typeof i[t])return t;v=["Moz","Webkit","Khtml","O","ms","Icab"],pu=t.charAt(0).toUpperCase()+t.substr(1);for(var e=0;e<v.length;e++)if("string"==typeof i[v[e]+pu])return"-"+v[e].toLowerCase()+"-"+t},t.fn.djswipe=t.fn.djswipe||function(i){function s(t){var i,s,o=t.originalEvent.changedTouches||e.originalEvent.touches,a=o[0].pageX,d=o[0].pageY;return i=a>n.x?"right":"left",s=d>n.y?"down":"up",{direction:{x:i,y:s},offset:{x:Math.abs(a-n.x),y:Math.abs(n.y-d)}}}var o=!1,n=null,a=null;return $el=t(this),$el.on("touchstart",function(t){o=!0;var i=t.originalEvent.changedTouches||e.originalEvent.touches;n={x:i[0].pageX,y:i[0].pageY}}),$el.on("touchend",function(){o=!1,a&&i(a.direction,a.offset),n=null,a=null}),$el.on("touchmove",function(t){o&&(a=s(t))}),!0}}(jQuery);